<?php
declare(strict_types=1);
require_once __DIR__ . '/config.php';

function e(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function redirect(string $path): void {
  header('Location: ' . BASE_URL . ltrim($path, '/'));
  exit;
}

function flash_set(string $type, string $msg): void {
  $_SESSION['flash'] = ['type' => $type, 'msg' => $msg];
}

function flash_get(): ?array {
  if (!isset($_SESSION['flash'])) return null;
  $f = $_SESSION['flash'];
  unset($_SESSION['flash']);
  return $f;
}

function now_iso(): string {
  return (new DateTimeImmutable('now'))->format('Y-m-d H:i:s');
}

function parse_date(string $s): ?DateTimeImmutable {
  $dt = DateTimeImmutable::createFromFormat('Y-m-d', $s);
  if (!$dt) return null;
  $errs = DateTimeImmutable::getLastErrors();
  if (!empty($errs['warning_count']) || !empty($errs['error_count'])) return null;
  return $dt;
}

function days_between_inclusive(string $start, string $end): int {
  $a = parse_date($start);
  $b = parse_date($end);
  if (!$a || !$b) return 0;
  $diff = (int)$b->diff($a)->format('%r%a');
  // inclusive: end-start + 1
  return abs($diff) + 1;
}

function money(int $ars): string {
  return '$' . number_format($ars, 0, ',', '.');
}
