<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';
$f = flash_get();
$u = current_user();
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= e(APP_NAME) ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    .glass { backdrop-filter: blur(12px); background: rgba(255,255,255,.75); }
  </style>
</head>
<body class="bg-slate-50 text-slate-900">
<header class="sticky top-0 z-30 border-b border-slate-200 bg-white/90 backdrop-blur">
  <div class="mx-auto max-w-6xl px-4 py-3 flex items-center justify-between gap-3">
    <a href="<?= BASE_URL ?>index.php" class="flex items-center gap-2">
      <div class="h-9 w-9 rounded-2xl bg-slate-900 text-white grid place-items-center font-semibold">M</div>
      <div class="leading-tight">
        <div class="font-semibold"><?= e(APP_NAME) ?></div>
        <div class="text-xs text-slate-500">Marketplace de carsharing</div>
      </div>
    </a>
    <nav class="flex items-center gap-2">
      <a class="px-3 py-2 rounded-xl hover:bg-slate-100 text-sm" href="<?= BASE_URL ?>search.php">Buscar</a>
      <?php if (!$u): ?>
        <a class="px-3 py-2 rounded-xl hover:bg-slate-100 text-sm" href="<?= BASE_URL ?>login.php">Ingresar</a>
        <a class="px-3 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800 text-sm" href="<?= BASE_URL ?>register.php">Crear cuenta</a>
      <?php else: ?>
        <?php if ($u['role'] === 'owner'): ?>
          <a class="px-3 py-2 rounded-xl hover:bg-slate-100 text-sm" href="<?= BASE_URL ?>dashboard_owner.php">Panel dueño</a>
        <?php elseif ($u['role'] === 'admin'): ?>
          <a class="px-3 py-2 rounded-xl hover:bg-slate-100 text-sm" href="<?= BASE_URL ?>admin.php">Admin</a>
        <?php else: ?>
          <a class="px-3 py-2 rounded-xl hover:bg-slate-100 text-sm" href="<?= BASE_URL ?>dashboard_user.php">Mis reservas</a>
        <?php endif; ?>
        <a class="px-3 py-2 rounded-xl hover:bg-slate-100 text-sm" href="<?= BASE_URL ?>logout.php">Salir</a>
      <?php endif; ?>
    </nav>
  </div>
</header>

<main class="mx-auto max-w-6xl px-4 py-6">
<?php if ($f): ?>
  <div class="mb-4 rounded-2xl border p-4 <?= $f['type']==='ok'?'border-emerald-200 bg-emerald-50':'border-rose-200 bg-rose-50' ?>">
    <div class="font-medium"><?= e($f['msg']) ?></div>
  </div>
<?php endif; ?>
