<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/helpers.php';

require_role('admin');
$pdo = db();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_verify();
  $action = $_POST['action'] ?? '';

  if ($action==='car_status') {
    $carId = (int)($_POST['car_id'] ?? 0);
    $status = $_POST['status'] ?? 'pending';
    if ($carId && in_array($status,['pending','active','suspended'],true)) {
      $pdo->prepare("UPDATE cars SET status=? WHERE id=?")->execute([$status, $carId]);
      flash_set('ok','Estado de auto actualizado.');
    }
    redirect('admin.php');
  }

  if ($action==='confirm_payment') {
    $paymentId = (int)($_POST['payment_id'] ?? 0);
    if ($paymentId) {
      $p = $pdo->prepare("SELECT * FROM payments WHERE id=?");
      $p->execute([$paymentId]);
      $pay = $p->fetch();
      if ($pay && $pay['status']==='pending') {
        $pdo->prepare("UPDATE payments SET status='confirmed' WHERE id=?")->execute([$paymentId]);
        $pdo->prepare("UPDATE bookings SET status='paid' WHERE id=?")->execute([(int)$pay['booking_id']]);
        flash_set('ok','Pago confirmado y reserva marcada como pagada.');
      }
    }
    redirect('admin.php');
  }
}

$pendingCars = $pdo->query("SELECT c.*, u.name as owner_name, u.email as owner_email
                           FROM cars c JOIN users u ON u.id=c.owner_id
                           WHERE c.status='pending' ORDER BY c.created_at DESC")->fetchAll();

$payments = $pdo->query("SELECT p.*, b.car_id, b.total, b.status as booking_status, c.title as car_title, u.email as renter_email
                         FROM payments p
                         JOIN bookings b ON b.id=p.booking_id
                         JOIN cars c ON c.id=b.car_id
                         JOIN users u ON u.id=b.renter_id
                         WHERE p.status='pending'
                         ORDER BY p.created_at DESC")->fetchAll();

require_once __DIR__ . '/_layout_top.php';
?>
<div class="max-w-6xl mx-auto space-y-6">
  <div>
    <h2 class="text-2xl font-semibold">Admin</h2>
    <div class="text-slate-600">Aprobaciones de autos y confirmación de pagos.</div>
  </div>

  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <h3 class="text-lg font-semibold">Autos pendientes</h3>
    <div class="mt-4 space-y-3">
      <?php foreach ($pendingCars as $c): ?>
        <div class="rounded-2xl border border-slate-200 p-4">
          <div class="flex items-start justify-between gap-4">
            <div>
              <div class="font-semibold"><?= e($c['title']) ?></div>
              <div class="text-sm text-slate-600"><?= e($c['city'] ?? '') ?> · <?= money((int)$c['price_per_day']) ?>/día · dueño: <?= e($c['owner_name']) ?> (<?= e($c['owner_email']) ?>)</div>
              <div class="text-xs text-slate-500 mt-1">Modo: <?= e($c['booking_mode']) ?></div>
            </div>
            <form method="post" class="flex gap-2 items-center">
              <?= csrf_input() ?>
              <input type="hidden" name="action" value="car_status">
              <input type="hidden" name="car_id" value="<?= (int)$c['id'] ?>">
              <select name="status" class="rounded-xl border-slate-200">
                <option value="active">Activar</option>
                <option value="pending">Pendiente</option>
                <option value="suspended">Suspender</option>
              </select>
              <button class="px-3 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800 text-sm">Guardar</button>
            </form>
          </div>
        </div>
      <?php endforeach; ?>
      <?php if (!$pendingCars): ?>
        <div class="text-sm text-slate-500">No hay autos pendientes.</div>
      <?php endif; ?>
    </div>
  </div>

  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <h3 class="text-lg font-semibold">Pagos pendientes</h3>
    <div class="mt-4 space-y-3">
      <?php foreach ($payments as $p): ?>
        <div class="rounded-2xl border border-slate-200 p-4">
          <div class="flex items-start justify-between gap-4">
            <div>
              <div class="font-semibold"><?= e($p['car_title']) ?> <span class="text-slate-400 font-normal">Reserva #<?= (int)$p['booking_id'] ?></span></div>
              <div class="text-sm text-slate-600">Renter: <?= e($p['renter_email']) ?> · Monto: <span class="font-semibold"><?= money((int)$p['amount']) ?></span></div>
              <div class="text-xs text-slate-500 mt-1">Método: <?= e($p['method']) ?> · Ref: <span class="font-mono"><?= e($p['reference'] ?? '-') ?></span></div>
            </div>
            <form method="post">
              <?= csrf_input() ?>
              <input type="hidden" name="action" value="confirm_payment">
              <input type="hidden" name="payment_id" value="<?= (int)$p['id'] ?>">
              <button class="px-3 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800 text-sm">Confirmar</button>
            </form>
          </div>
        </div>
      <?php endforeach; ?>
      <?php if (!$payments): ?>
        <div class="text-sm text-slate-500">No hay pagos pendientes.</div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
