<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/helpers.php';

require_login();

$id = (int)($_GET['id'] ?? 0);
$pdo = db();

$stmt = $pdo->prepare("SELECT b.*, c.title as car_title, c.booking_mode, c.owner_id
                       FROM bookings b JOIN cars c ON c.id=b.car_id
                       WHERE b.id=? AND b.renter_id=?");
$stmt->execute([$id, current_user()['id']]);
$b = $stmt->fetch();
if (!$b) { http_response_code(404); exit('Reserva no encontrada.'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  if ($b['status'] !== 'pending_payment') {
    flash_set('err','La reserva no está lista para pagar (debe estar pendiente de pago).');
    redirect('dashboard_user.php');
  }
  $ref = trim($_POST['reference'] ?? '');
  if (strlen($ref) < 4) { flash_set('err','Ingresá una referencia válida de transferencia.'); redirect('booking_pay.php?id='.$id); }

  // create payment record
  $ins = $pdo->prepare("INSERT INTO payments (booking_id, method, status, amount, reference) VALUES (?,?,?,?,?)");
  $ins->execute([$id, 'bank_transfer', 'pending', (int)$b['total'], $ref]);

  flash_set('ok','Transferencia informada. Queda pendiente de verificación.');
  redirect('dashboard_user.php');
}

require_once __DIR__ . '/_layout_top.php';
?>
<div class="max-w-3xl mx-auto">
  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <div class="flex items-start justify-between gap-4">
      <div>
        <h2 class="text-2xl font-semibold">Pagar reserva #<?= (int)$b['id'] ?></h2>
        <div class="text-slate-600 mt-1"><?= e($b['car_title']) ?> · <?= e($b['start_date']) ?> → <?= e($b['end_date']) ?> (<?= (int)$b['days'] ?> días)</div>
      </div>
      <div class="text-right">
        <div class="text-sm text-slate-500">Total</div>
        <div class="text-2xl font-semibold"><?= money((int)$b['total']) ?></div>
      </div>
    </div>

    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
      <div class="rounded-2xl border border-slate-200 bg-slate-50 p-5">
        <div class="font-semibold">Transferencia bancaria</div>
        <div class="text-sm text-slate-700 mt-2 space-y-1">
          <div><span class="text-slate-500">Banco:</span> <?= e(BANK_NAME) ?></div>
          <div><span class="text-slate-500">Titular:</span> <?= e(BANK_HOLDER) ?></div>
          <div><span class="text-slate-500">Alias:</span> <?= e(BANK_ALIAS) ?></div>
          <div><span class="text-slate-500">CBU:</span> <?= e(BANK_CBU) ?></div>
          <div class="mt-2 text-xs text-slate-500">Referencia sugerida: <span class="font-mono">BOOKING-<?= (int)$b['id'] ?></span>. <?= e(BANK_NOTE) ?></div>
        </div>
      </div>

      <div class="rounded-2xl border border-slate-200 p-5">
        <div class="font-semibold">Informar pago</div>
        <div class="text-sm text-slate-600 mt-1">Después de transferir, cargá el número de operación / referencia.</div>

        <?php if ($b['status'] !== 'pending_payment'): ?>
          <div class="mt-4 text-rose-700 text-sm">Esta reserva no está en estado pendiente de pago.</div>
        <?php else: ?>
          <form method="post" class="mt-4 space-y-3">
            <?= csrf_input() ?>
            <div>
              <label class="text-xs text-slate-500">Referencia / comprobante</label>
              <input name="reference" class="mt-1 w-full rounded-xl border-slate-200" placeholder="Ej: 0001234567" required>
            </div>
            <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 hover:bg-slate-800">Enviar</button>
          </form>
        <?php endif; ?>

        <div class="mt-4 text-xs text-slate-500">Un admin confirmará el pago. Una vez confirmado, la reserva pasa a “Pagada”.</div>
      </div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
