<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/availability.php';
require_once __DIR__ . '/../app/csrf.php';

$id = (int)($_GET['id'] ?? 0);
$start = trim($_GET['start'] ?? '');
$end = trim($_GET['end'] ?? '');

$pdo = db();
$stmt = $pdo->prepare("SELECT c.*, u.name as owner_name FROM cars c JOIN users u ON u.id=c.owner_id WHERE c.id=? AND c.status='active'");
$stmt->execute([$id]);
$car = $stmt->fetch();
if (!$car) { http_response_code(404); exit('Auto no encontrado.'); }

$photos = $pdo->prepare("SELECT * FROM car_photos WHERE car_id=? ORDER BY sort_order ASC, id ASC");
$photos->execute([$id]);
$photos = $photos->fetchAll();

$isAvail = ($start && $end) ? car_is_available($id, $start, $end) : null;

require_once __DIR__ . '/_layout_top.php';
?>
<div class="grid grid-cols-1 lg:grid-cols-5 gap-6">
  <div class="lg:col-span-3">
    <div class="rounded-3xl border border-slate-200 bg-white overflow-hidden">
      <?php if ($photos): ?>
        <div class="aspect-[16/10] bg-slate-100">
          <img src="<?= e($photos[0]['path']) ?>" class="w-full h-full object-cover">
        </div>
        <?php if (count($photos) > 1): ?>
          <div class="p-4 grid grid-cols-4 gap-2">
            <?php foreach (array_slice($photos, 1, 8) as $p): ?>
              <img src="<?= e($p['path']) ?>" class="w-full aspect-square object-cover rounded-xl border border-slate-200">
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      <?php else: ?>
        <div class="aspect-[16/10] bg-slate-100 grid place-items-center text-slate-400">Sin fotos</div>
      <?php endif; ?>
    </div>

    <div class="mt-5 rounded-3xl border border-slate-200 bg-white p-6">
      <div class="flex items-start justify-between gap-3">
        <div>
          <h1 class="text-2xl font-semibold"><?= e($car['title']) ?></h1>
          <div class="text-slate-600 mt-1"><?= e($car['city'] ?? '') ?> · Punto fijo · Dueño: <?= e($car['owner_name']) ?></div>
        </div>
        <span class="text-xs px-2 py-1 rounded-full <?= $car['booking_mode']==='instant'?'bg-emerald-50 text-emerald-700':'bg-amber-50 text-amber-700' ?>">
          <?= $car['booking_mode']==='instant'?'Instant':'Aprobación' ?>
        </span>
      </div>

      <div class="mt-4 grid grid-cols-2 md:grid-cols-4 gap-3 text-sm">
        <div class="rounded-2xl border border-slate-200 p-3"><div class="text-slate-500 text-xs">Marca</div><div class="font-medium"><?= e($car['make'] ?? '-') ?></div></div>
        <div class="rounded-2xl border border-slate-200 p-3"><div class="text-slate-500 text-xs">Modelo</div><div class="font-medium"><?= e($car['model'] ?? '-') ?></div></div>
        <div class="rounded-2xl border border-slate-200 p-3"><div class="text-slate-500 text-xs">Año</div><div class="font-medium"><?= e((string)($car['year'] ?? '-')) ?></div></div>
        <div class="rounded-2xl border border-slate-200 p-3"><div class="text-slate-500 text-xs">Transmisión</div><div class="font-medium"><?= e($car['transmission'] ?? '-') ?></div></div>
      </div>

      <div class="mt-4">
        <div class="text-sm font-semibold">Punto de entrega</div>
        <div class="text-sm text-slate-600"><?= e($car['pickup_address'] ?? 'A coordinar') ?></div>
      </div>

      <?php if (!empty($car['rules'])): ?>
      <div class="mt-4">
        <div class="text-sm font-semibold">Reglas</div>
        <div class="text-sm text-slate-600 whitespace-pre-line"><?= e($car['rules']) ?></div>
      </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="lg:col-span-2">
    <div class="sticky top-24 rounded-3xl border border-slate-200 bg-white p-6">
      <div class="text-2xl font-semibold"><?= money((int)$car['price_per_day']) ?><span class="text-sm text-slate-500 font-normal"> / día</span></div>
      <div class="text-sm text-slate-600 mt-1">Fee plataforma: <?= (int)(SERVICE_FEE_RATE*100) ?>% · Pendiente hasta pago</div>

      <form action="booking_create.php" method="post" class="mt-5 space-y-3">
        <?= csrf_input() ?>
        <input type="hidden" name="car_id" value="<?= (int)$car['id'] ?>">
        <div class="grid grid-cols-2 gap-2">
          <div>
            <label class="text-xs text-slate-500">Desde</label>
            <input type="date" name="start" value="<?= e($start) ?>" class="mt-1 w-full rounded-xl border-slate-200" required>
          </div>
          <div>
            <label class="text-xs text-slate-500">Hasta</label>
            <input type="date" name="end" value="<?= e($end) ?>" class="mt-1 w-full rounded-xl border-slate-200" required>
          </div>
        </div>

        <?php if ($start && $end): ?>
          <div class="text-sm <?= $isAvail?'text-emerald-700':'text-rose-700' ?>">
            <?= $isAvail?'Disponible para esas fechas':'No disponible para esas fechas' ?>
          </div>
        <?php endif; ?>

        <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 hover:bg-slate-800">Reservar</button>

        <div class="text-xs text-slate-500">Si el auto es “Aprobación”, el dueño debe aceptar antes del pago.</div>
      </form>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
