<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

if (current_user()) redirect('index.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $email = strtolower(trim($_POST['email'] ?? ''));
  $pass = (string)($_POST['password'] ?? '');

  $pdo = db();
  $stmt = $pdo->prepare('SELECT * FROM users WHERE email=?');
  $stmt->execute([$email]);
  $u = $stmt->fetch();

  if (!$u || !password_verify($pass, $u['password_hash'])) {
    flash_set('err', 'Credenciales inválidas.');
    redirect('login.php');
  }

  login_user($u);
  flash_set('ok', 'Ingresaste correctamente.');
  redirect('index.php');
}

require_once __DIR__ . '/_layout_top.php';
?>
<div class="max-w-xl mx-auto">
  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <h2 class="text-2xl font-semibold">Ingresar</h2>
    <p class="text-slate-600 mt-1">Accedé a tu cuenta.</p>

    <form method="post" class="mt-6 space-y-4">
      <?= csrf_input() ?>
      <div>
        <label class="text-sm text-slate-600">Email</label>
        <input name="email" type="email" class="mt-1 w-full rounded-xl border-slate-200" required>
      </div>
      <div>
        <label class="text-sm text-slate-600">Contraseña</label>
        <input name="password" type="password" class="mt-1 w-full rounded-xl border-slate-200" required>
      </div>
      <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 hover:bg-slate-800">Ingresar</button>
    </form>

    <div class="mt-4 text-sm text-slate-600">
      ¿No tenés cuenta? <a class="underline" href="register.php">Crear cuenta</a>
    </div>

    <div class="mt-6 rounded-2xl border border-slate-200 bg-slate-50 p-4 text-sm text-slate-700">
      <div class="font-semibold">Admin (demo)</div>
      <div>Email: admin@movecarsharing.com</div>
      <div>Pass: Admin123!</div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
